%%%
%%% @(#) tuc-beamer.cls -- pseudo class for thesis at Clausthal University
%%%
%%% Time-stamp:  <2016-11-30 15:03:28 tmjb>
%%%
%%%
%%% @(#) $Id: $
%%% @(#) $Keywords: TU Clausthal, TUC, CD, Corporate Design, Presentation, Vortrag, Slides, Folien, LaTeX $
%%%
%%%
%%%          File: /usr/local/texmf/tex/latex/TUC/tuc-beamer.cls
%%%       Project: TUC-BEAMER
%%%       Version: $Revision: $
%%%   Description: Master class to create slides for presentations
%%%        Author: tmjb -- Jan Braun <Jan.Braun@tu-clausthal.de>
%%%    Maintainer: tmjb -- Jan Braun <Jan.Braun@tu-clausthal.de>
%%% Creation-Date: Wed 11  May 2016 -- Jan Braun <Jan.Braun@tu-clausthal.de>
%%%     Copyright: (c) 2016 Jan Braun
%%%

%%% ------------------------------------------------------ &Change Log ---
%%%
%%% $Log:  $


%%% ============================================================ &Code ===

%%% ---------------------------------------------------- &Package Name ---
% \NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{tuc-beamer}[2016/06/02 v0.01  TU Clausthal]


%%% ------------------------------------------------------- &Variables ---
%% We need some variables, to store and indicate which options (see
%% later) are choosen ...
\newif\if@draft                 % for Option draft
\newif\if@final                 % Oposite of draft
\newif\if@tucfont               % use the corporate design font
\newif\if@afourpaper            % papersize DIN A4
\newif\if@afivepaper            % papersize DIN A5
\newif\if@letter                % american letter papersize
\newif\if@english               % use english language and logos
\newif\if@tuctitle              % Use the TUC titlepage.



%%% --------------------------------------------------------- &Options ---

%% ............................................................ &draft ...
%% Option draft is per default defined by the main class package,
%% unless you specify final.  This style defines it for continuity
%% reasons.  Draft and final are mutualy exclusive
\DeclareOption{draft}{%
  \@drafttrue
  \@finalfalse
  \PassOptionsToClass{draft}{beamer}
  \PassOptionsToPackage{draft}{tuc-cd}
}

%% ............................................................ &Final ...
%% Option final is set, when you intend to print the final copy of
%% your work.
\DeclareOption{final}{%
  \@draftfalse
  \@finaltrue
  \PassOptionsToClass{final}{beamer}
  \PassOptionsToPackage{final}{tuc-cd}
}

%% .......................................................... &TUCFont ...
%% Option final is set, when you intend to print the final copy of
%% your work.
\DeclareOption{tucfont}{%
  \@tucfonttrue%
  \PassOptionsToPackage{tucfont}{tuc-cd}%
}%

%% .......................................................... &A4paper ...
%% Option a4paper is set, to typeset on DIN A4 papersize.  It should
%% be the Default size.
\DeclareOption{a4paper}{%
  \@afourpapertrue
  \@afivepaperfalse
  \@letterfalse
  \PassOptionsToClass{a4paper}{beamer}
  \PassOptionsToPackage{a4paper}{tuc-cd}
}

%% .......................................................... &A5paper ...
%% Option a5paper is set, to typeset on DIN A4 papersize.
\DeclareOption{a5paper}{%
  \@afourpaperfalse
  \@afivepapertrue
  \@letterfalse
  \PassOptionsToClass{a5paper}{beamer}
  \PassOptionsToPackage{a5paper}{tuc-cd}
}


%% ...................................................... &letterpaper ...
%% Option letterpaper is set, to typeset on american letter papersize.
\DeclareOption{letterpaper}{%
  \@afourpaperfalse
  \@afivepaperfalse
  \@lettertrue
  \PassOptionsToClass{letter}{beamer}
  \PassOptionsToPackage{letter}{tuc-cd}
}

%% .......................................................... &ngerman ...
%% Option german is set, when your work is primarily in german language.
\DeclareOption{ngerman}{%
  \@englishfalse
  \PassOptionsToPackage{german}{tuc-cd}
  \PassOptionsToPackage{ngerman}{babel}
}

%% ........................................................... &german ...
%% Option german is set, when your work is primarily in german language.
\DeclareOption{german}{%
  \@englishfalse
  \PassOptionsToPackage{german}{tuc-cd}
  \PassOptionsToPackage{german}{babel}
}

%% .......................................................... &english ...
%% Option english is set, when your work is primarily in english language.
\DeclareOption{english}{%
  \@englishtrue
  \PassOptionsToPackage{english}{tuc-cd}
  \PassOptionsToPackage{english}{babel}
}

%% ........................................................ &tuc-title ...
%% Option tuctitle should be used, when you want to have a different
%% style for the title page.
\DeclareOption{tuctitle}{%
  \@tuctitletrue
}


%% ....................................................... &Undeclared ...
%% This one is for any option, which was not declared before.
\DeclareOption*{%
  \typeout{^^J tuc-beamer.cls: Handing current option {\CurrentOption} to class beamer ^^J }%
  \PassOptionsToClass{\CurrentOption}{beamer}%
}%
%% Set the options.
\ExecuteOptions{final,ngerman,a4paper}%
\ProcessOptions\relax



%%% ---------------------------------------------------------- &Classes ---
%% 
%% Load the required class
\LoadClass{beamer}

%%% --------------------------------------------------------- &Packages ---
%%
%% To get all definitions of this style to work, we need some more
%% packages.  They are automatically loaded here.
%%
%% ............................................................ &Colors ...
%% load the TUC-Colors.  If the presentation will be presented on a
%% beamer, the colors should be in RGB-mode, otherwise in CMYK.
\mode<beamer>{%
  \RequirePackage[rgb,beamer]{tuc-cd}  % used to define the correct colors
}%
\mode<article| handout| trans>{%
  \RequirePackage[cmyk,beamer]{tuc-cd} % used for the colored lines, e. g.
}%
%% 
%% .............................................................. &Misc ...
\RequirePackage{pgfpages}            % Ausgabe als Handout
\RequirePackage{hyperref}            % Hyperlinks usw.


%%% ------------------------------------------------------ &Definitions ---

%% ........................................................ &Titlepages ...
%% 
%% Beamer knows to different ways to set a titlepage.  The one is used
%% for frames (AKA slides) and the other one is used by regular
%% article or scrartcl-class.  in case of typesetting an article, the
%% latter class should be used.
%% 
%% This new command should be used to create a titlepage, followed by
%% an outline.  It handles a presentation or an article accordingly.
%% To do so, let's define to headline for the Outline page.
% \def\@outlinename{Outline}%
% \newcommand{\outlinename}[1]{%
%   \def\@outlinename{#1}}%
% \newcommand{\titleoutline}{%
%   % first, for the presentations
%   \mode<presentation>{%
%     % Titelseite
%     \begin{frame}%
%       \titlepage%
%     \end{frame}%
%     % Inhaltsverzeichnis
%     \begin{frame}%
%       \frametitle{\@outlinename}%
%       \tableofcontents[hideallsubsections]%
%     \end{frame}%
%   }%
%   % And again for the paper printed article
%   \mode<article>{%
%     \thispagestyle{empty}%
%     \maketitle%
%     \if@twoside%
%       \cleardoublepage%
%       \tableofcontents%
%       \cleardoublepage%
%     \else%
%       \clearpage%
%       \tableofcontents%
%       \clearpage%
%     \fi%
%   }%
% }%




%%% ------------------------------------------------------------- &Code --- 
%% ............................................................ &Design ...
%% 
%% use the TUC theme for this presentations
\usetheme{TUC}
%% Save paper.  Use at least 4 slides on one sheet of paper.  (Print
%% twoside, to save even more!)
\mode<handout>{\pgfpagesuselayout{4 on 1}[a4paper,landscape,border shrink=5mm]}




%%% ------------------------------------------------------- &Variables ---


%%% --------------------------------------------------------- &Commands ---



%%% ============================================================= &EOF ===

%%% Local Variables:
%%% mode: LaTeX
%%% TeX-master: "~/Documents/RZ/Weiterbildung/LaTeX/Folien/beispiel-folien.tex"
%%% TeX-parse-self: t
%%% TeX-auto-save: t
%%% End:


