# LaTeX Pakete zum Corporate Design der TU Clausthal #

Dieses Verzeichnis beinhaltet eine Reihe von LaTeX-Pakete und Klassen,
um das Corporate Design der TU Clausthal in LaTeX umzusetzen.

Aktuelle Version: 0.8.0
## Inhalte ##

### Klassen ###

### `tuc-thesis.cls` ###

Die Klasse `tuc-thesis` eignet sich zur Anfertigung von
Abschlussarbeiten aller Art:

- Bachelorarbeiten,
- Masterarbeiten,
- Doktorarbeiten.

Die Klasse ist in der Lage, ein gesondertes Deckblatt mit den
notwendigen, zusätzlichen Angaben (Institutsname, Fakultät, Gutachter,
Abgabetermine, usw.) zu erzeugen.  Weiterhin wird ein Befehl zur
Verfügung gestellt, mit dem die eidesstattliche Erklärung erzeugt wird,
die der aktuellen Allgemeinen Prüfungsordnung (APO) entspricht.

#### `tuc-beamer.cls` ####

Mit Hilfe der `tuc-beamer`-Klasse können Präsentationen mit Folien,
Handouts und weiteren Formaten erzeugt werden.

#### `tuc-letter.cls` ####

Die `tuc-letter`-Klasse erstellt Briefe im Corporate Design der TU
Clausthal.  Über hierarchische, vorgefertigte Konfigurationsdateien
können die notwendigen Anpassungen für den persönlichen, individuellen
Briefkopf auf das Minimum reduziert werden.

### Style-Dateien ###

#### `tuc-cd.sty` ####

Die Style-Datei `tuc-cd` ist im wesentlichen eine Meta-Datei, die dafür
sorgt, dass alle Teilaspekte des Corporate Designs (Farben, Schriften)
definiert werden.  Sie lädt intern die beiden nachfolgend genannten
Style-Dateien.

#### `tuc-colors.sty` ####

`tuc-colors.sty` definiert die Hausfarben der TU Clausthal in den
Farbräumen CMYK (Printmedien) und RGB (Webseiten, Computer, ...)


#### `tuc-fonts.sty` ####

Die Styledatei `tuc-fonts.sty` sorgt dafür, dass die Hausschriften
genutzt werden können.  Dazu müssen die Schriften auf dem jeweiligen
Rechner installiert sein.  (Sieh dazu [Schriften](schriften).)

## Dokumentation der Klassen und Dateien ##

Im Verzeichnis `doc` sind die entsprechenden Dateien zur Dokumentation
der Klassen und Pakete enthalten.  Sie finden darin TeX-Dateien, die
die typische Benutzung der bereitgestellten Klassen in einem mehr oder
minder minimalen Beispiel zeigen.

Die Datei `tuc-thesis.tex` hingegen ist eine umfangreiche Datei und
erläutert zu jeder Klasse und jedem Paket die Besonderheiten, die
neuen Befehle und Optionen mit allen Einzelheiten.  Sie stellt
gleichzeitig auch eine Art Vorlage, die zur Anfertigung von
Abschlussarbeiten herangenommen werden kann.

Um die Datei `tuc-thesis.pdf` erstellen zu können, benötigen Sie aber
die Datei `weiterbildung.sty` die Sie z. B. aus dem
[Dokuwiki laden können](https://doku.tu-clausthal.de/doku.php?id=software_und_lizenzen:freie_software:texlive#umsetzung_des_corporate_design).
Weiterhin wird das Paket `minted.sty` benötigt, dass bereits mit ihrem
Grundsystem installiert sein sollte.  Minted selber nutzt einen
Phython-Interpreter, der ebenfalls vorhanden sein muss.

## Verzeichnisse in der Archiv-Datei

Der Ordner `latex` enthält die eigentlichen Klassen und Pakete.  Die
Dateien, die in den jeweiligen Ordnern enthalten sind, müssen in die
passenden Verzeichnisse gleichen Namens in ihrem TeX-System kopiert
werden, siehe [Installation](installation).

Der Ordner `doc` enthält die bereits genannten Dokumentationen zu den
Klassen und Paketen.  Bitte installieren Sie diesen Ordner ebenfalls
in ihrem TeX-System.

## Schriften ##

Bitte beachten Sie: die im Corporate Design der TU Clausthal
vorgesehenen Schriften "ITC Stone Serif" und "ITC Stone Sans" sind
nicht Bestandteil dieses Archivs.  Sie müssen gesondert beim RZ
bestellt werden und entsprechend auf Ihrem PC installiert werden.  Die
Schriften sind lizenzpflichtig und dürfen daher nur auf dienstlichen
Geräten der TU Clausthal installiert werden!

## Installation ##

Es empfiehlt sich, die Dateien in die entsprechenden Verzeichnissen
Ihrer TeX-Distribution zu kopieren.  Idealerweise sollten Sie dabei
die TDS (TeX Directory Structure) beachten.

### TeX-Live ###

#### System überprüfen ####

Ob ein TeXLive-System (z. B. TeXLive, aber auch MacTeX) genutzt wird,
man in einem Terminal (Linux, MacOS) bzw. einem Command-Shell
(Windows) wie folgt feststellen:

```shell
tlmgr version
```

Sofern an dieser Stelle keine Fehlermeldung ausgegeben wird, ist ein
TeX-Live-System installiert.

Das Programm `tlmgr` ist das Verwaltungswerkzeug einer
TeXLive-Installation.  Es steht kurz für TeXLive-Manager.

Damit kann man sich auch die aktuelle Konfiguration des TeX-Systems
ausgeben lassen:

```shell
tlmgr conf
```
#### Automatische Installation ####

Je nach Plattform unterscheidet sich die automatische Installation per
Skript nur minimal.  Auf einem GNU/Linux oder einem Apple MacOS System
wird das Skript `install-tuc-cd.sh` verwendet.  Auf einem
Windowssystem sollten Sie das Skript `install-tuc-cd.cmd` verwenden.

Die Skripte versuchen selbständig herauszufinden, ob Sie für
den 2. Bereich Schreibrechte haben.  Falls ja, legt das Script die
entsprechenden Unterordner

```shell
$TEXMFLOCAL/doc/tex/latex/TUC
$TEXMFLOCAL/tex/latex/TUC
```

an und kopiert die Dokumentationsdateien in den erstgenannten Ordner,
bzw. die Klassen und Pakete in den zweitgenannten Ordner.


#### Manuelle Installation ####

Bitte nutzen Sie den Befehl `tlmgr conf` um die Konfiguration ihrer
TeX Installation zu überprüfen.   In dem Abschnitt `kpathsea variables`
werden diejenigen Bereiche angegeben, in denen TeX nach seinen
Dateien sucht.  Dabei werden prinzipiell drei Speicherbereiche
unterschieden:

  1) `TEXMFDIST`: Der Bereich, der den Verwaltern der Distribution
  vorbehalten bleibt, hier den TeXLive-Entwicklern.

  2) `TEXMFLOCAL`: Der Bereich des lokalen Systemverwalters

  3) `TEXMFHOME`: Der individuelle Bereich des jeweiligen Users

Wenn Sie Systemadministrator einer Site (wie der TU Clausthal) sind
und in dem genannten Ordner über Schreibrechte verfügen, dann sollten
Sie die tuc-cd Pakete und Dateien im 2. Bereich (`TEXMFLOCAL`) ablegen.
Keinesfalls sollten Sie die Klassen und Pakete im 1. Bereich
(`TEXMFDIST`) ablegen, da sie beim nächsten Update des TeX-Systems ohne
Vorwarnung oder Rückfrage überschrieben werden!

Wenn Sie die TU-Clausthal-Klassen und Pakete im 2. Bereich ablegen,
dann dürfen Sie nicht vergessen, die TeX-Datenbank zu aktualisieren,
indem sie den Befehl

```shell
mktexlsr
```

oder

```shell
texhash
```

aufrufen.

Sollten Sie keine Schreibrechte für `TEXMFLOCAL` verfügen, dann müssen
Sie die Dateien in die persönlichen TeX-Verzeichnisse (`TEXMFHOME`)
kopieren.

### MikTeX ###

Zur Installation des TUC-CDs sollten Sie die hier zur Verfügung
gestellen Pakete und Klassen in ein von MikTeX überwachtes Verzeichnis 
kopieren. 

Um herauszufinden, welche Verzecihnisse von MikTex überwacht werden,
öffnen Sie das Programm "MikTeX Settings" (`mo.exe`).  Im Tab "Roots" sehen 
Sie alle von MikTeX überwachten Verzeichnisse. 

Wenn Sie zusätzlich den Kasten "Show MikTeX-maintained root directories" 
aktivieren sehen Sie zusätzliche Verzeichnisse, welche von MikTex verwaltet 
werden um den Inhalt der MikTeX-Distribution abzulegen.  Installieren Sie 
unter keinen Umständen die hier zur Verfügung gestellten Klassen und Paktete 
in diese Verzeichnisse. Bei einem Update werden diese überschrieben!

Daher erstellen Sie sich einen Ordner an einer beliebigen Stelle, z.B. in ihren
Benutzerverzeichnis. Fügen diesen mittels "Add" in MikTeX Options GUI (`mo.exe`)
hinzu und kopieren die Klassen und Pakete des TU-CD in dieses Verzeichnis. 
Wechseln Sie in den Tab "General" und klicken auf "Refresh FNDB" und "Update
Format" um die TeX-Datenbank zu aktualisieren. 



## Dokumentation zur Nutzung der Klassen und Dateien ##

Im Dokumentationsordner finden Sie eine Reihe von
Anwendungsbeispielen, mit denen die Benutzung der TUC-CD-Klassen
exemplarisch vorgeführt wird.  Im Wesentlichen finden Sie dort auch
die Datei tuc-thesis.tex, die eine ausführliche Anleitung zu den
TUC-CD-Klassen und Paketen enthält.  Gleichzeitig dient die
LaTeX-Datei dazu, ein Beispiel zu geben, wie man Abschlussarbeiten mit
der Klasse tuc-thesis in LaTeX dokumentieren kann.  Insbesondere zeigt
sie, wie man eine größere, umfangreiche Datei mit Hilfe des
`\include`-Befehls in mehrere kleinere Dateien aufspalten kann, was die
Bearbeitung und insbesondere die Fehlersuche erheblich vereinfachen
kann.

# Todo #
* [ ] Klasse für Scripte von @jw11 hinzufügen
* [ ] Klasse für Protokolle erstellen
  - [ ] @jher14 : Sitzungsprotokolle von Gremien, z. B.
	+ AStA
	+ Ältestenrat
	+ Studierendenparlament
	+ ...
  - [ ] Protokolle für Laborversuche
  + @skle : Organische Chemie
  + ...
* [ ] [Pakete von Phillipp Kraus hinzufügen]	(https://gitlab.tu-clausthal.de/TUC/TeX-Vorlagen)
* [ ] Dokumentation vervollständigen
* [ ] Dateien in selbstdokumentierte `dtx`-Pakete umwandeln
* [ ] Installationsskript für MikTeX erstellen
* [ ] Skript zur Erstellung der persönlichen Briefkonfiguration
  erstellen (@jw11) 
