﻿REM
REM @(#) install-tuc-cd.bat -- Try to install the TUC CD classes and packages into a TeXLive TDS structure
REM
REM Time-stamp:  <2019-11-19 11:09:39 tmjb>
REM
REM
REM @(#) $Keywords: TEXLive, TDS, TUC, Technische Universität Clausthal, Clausthal University of Technology, TUC-CD, Corporate Design $
REM
REM
REM          File: /Users/tmjb/Documents/LaTeX/Source/TUC/tuc-cd/install-tuc-cd.bat
REM       Project: TUC-CD
REM   Description: This script tries to determine, where your locals
REM                TeXLive-Systems stores its local, site wide TeX
REM                files ($TEXMFLOCAL).  If you are allowed to write
REM                to this directory, it will genererate the needed
REM                subdirectories and will store the TUC-CD styles and
REM                classes as well as the according documentation into
REM                that directories.  If it succedded successful, it
REM                will update the TeX database of files.  If you
REM                aren't allowed to write into the site wide local
REM                TeX directory, it will store the class- and package
REM                files as well as the documentation into your
REM                personal TeX directory ($TEXMFHOME).
REM       Version: 0.8.0
REM        Author: kh15 -- Kevin Heberle <heberle@rz.tu-clausthal.de>
REM    Maintainer: tmjb -- Jan Braun <braun@rz.tu-clausthal.de>
REM Creation-Date: Mon Nov 27 2017 -- Kevin Heberle <heberle@rz.tu-clausthal.de>
REM     Copyright: (c) 2017 Jan Braun
REM

echo off

echo LATEX Script: %~n0  & REM Gibt eigenen Dateinamen aus.

mkdir .\temp  & REM Erstellen eines temporären Ordners.
tlmgr conf > .\temp\tlmgrconf | Pause > NUL & REM Kopiert die ausgabe, des "tlmgr conf" Befehls in eine neue Datei.

REM TEXMFHOME:

findstr /b /i "texmfhome" .\temp\tlmgrconf > .\temp\TEXMFHOME & REM Sucht nach der TEXMFHOME Zeile und schreibt sie in eine neue Datei.
For /F "Tokens=1,2* Delims== " %%i IN (.\temp\TEXMFHOME) DO Echo %%j>>.\temp\TEXMFHOMETEMP & REM Schreibt den Pfad der TEXMFHOME in eine neue Datei.
set /p "TEXMFHOME="<".\temp\TEXMFHOMETEMP" & REM Setzt den TEXMFHOME Pfad in die Variable "TEXMFHOME".
set TEXMFHOME=%TEXMFHOME: =%

REM TEXMFLOCAL:

findstr /b /i "texmflocal" .\temp\tlmgrconf > .\temp\TEXMFLOCAL & REM Sucht nach der TEXMFLOCAL Zeile und schreibt sie in eine neue Datei.
For /F "Tokens=1,2* Delims== " %%i IN (.\temp\TEXMFLOCAL) DO Echo %%j>>.\temp\TEXMFLOCALTEMP & REM Filtert und schreibt den Pfad der TEXMFLOCAL in eine neue Datei.
set /p "TEXMFLOCAL="<".\temp\TEXMFLOCALTEMP" & REM Setzt den TEXMFLOCAL Pfad in die Variable "TEXMFLOCAL".
set TEXMFLOCAL=%TEXMFLOCAL: =%

echo. > %TEXMFLOCAL%\TEMP.txt & REM Erstellt eine Datei zur überprüfung der Schreibrechte.

REM Bestimmung des Pfades, wo die TEX Dateien hin kopiert werden:

if exist "%TEXMFLOCAL%\TEMP.txt" (
    mkdir "%TEXMFLOCAL%\doc\tex\latex\TUC"  & REM Erstellt Unterordner
    mkdir "%TEXMFLOCAL%\tex\latex\TUC"  & REM Erstellt Unterordner
	xcopy .\doc\*.* "%TEXMFLOCAL%\doc\tex\latex\TUC" /e & REM Kopiert die Dateien
    xcopy .\latex\*.* "%TEXMFLOCAL%\tex\latex\TUC" /e  & REM Kopiert die Dateien
	del "%TEXMFLOCAL%\TEMP.txt" /s /q & REM Löscht Temporäre Datei
) else (
    mkdir "%TEXMFHOME%\doc\tex\latex\TUC"  & REM Erstellt Unterordner
    mkdir "%TEXMFHOME%\tex\latex\TUC"  & REM Erstellt Unterordner
	xcopy .\doc\*.* "%TEXMFHOME%\doc\tex\latex\TUC" /e  & REM Kopiert die Dateien
    xcopy .\latex\*.* "%TEXMFHOME%\tex\latex\TUC" /e  & REM Kopiert die Dateien
)

mktexlsr  & REM Aktualisiert die TeX-Datenbank

REM Zurücksetzen der Variablen:

set "TEXMFHOME="
set "TEXMFLOCAL="
set "CHECKINSTALL="

rmdir .\temp /s /q & REM Löscht den temporären Ordner








