TITLE TUC OpenVPN Version 3.0.5
REM   Copyright 2025 Clausthal University of Technology
REM   Version: 3.0.5 20.11.2025
cls
@echo off

REM Abfrage ob die Batch Datei als Admin ausgeführt wird
mkdir "%windir%\system32\test" 2>nul
if "%errorlevel%" == "0" (rmdir "%windir%\system32\test") else (goto :keinadmin)

REM Aktuelles Verzeichnis in Variable schreiben
set verz=%~dp0

cls
echo VPN wird installiert.


REM Abfrage ob es Windows 10 oder 11 ist
for /f "tokens=4-5 delims=. " %%i in ('ver') do set VERSION=%%i.%%j
if "%version%" == "11.0" (goto :supp)
if "%version%" == "10.0" (goto :supp) else (goto :nsupp)


:supp

REM   evtl. vorhandenes OpenVPN stoppen
start /wait taskkill /IM openvpn-gui.exe
start /wait net stop OpenVPNServiceInteractive
start /wait taskkill /IM openvpnserv.exe
REM   alte Firewall Regeln löschen
netsh advfirewall firewall delete rule name="TUC OpenVPN UDP" > nul
netsh advfirewall firewall delete rule name="TUC OpenVPN TCP" > nul

REM Abfrage 32 oder 64 Bit
if "%PROCESSOR_ARCHITECTURE%"=="AMD64" (goto :64) else (goto :32)


:64
REM Installation in msi umbenennen
ren "%verz%OpenVPN-2.6.16-I001-amd64.tuc" "OpenVPN-2.6.16-I001-amd64.msi"
REM   OpenVPN Client installieren
start /wait "OpenVPN Installation" MsiExec.exe /i "%verz%OpenVPN-2.6.16-I001-amd64.msi" /qn
goto :beide

:32
REM Installation in msi umbenennen
ren "%verz%OpenVPN-2.6.16-I001-x86.tuc" "OpenVPN-2.6.16-I001-x86.msi"
REM   OpenVPN Client installieren
start /wait "OpenVPN Installation" MsiExec.exe /i "%verz%OpenVPN-2.6.16-I001-x86.msi" /qn
goto :beide

:nsupp
@echo off
cls
echo.
echo =============================================
echo *                                           *
echo *    VPN konnte nicht installiert werden    *
echo *    Ihre Windows Version wird nicht        *
echo *    unterstuetzt                           *
echo *                                           *
echo =============================================
goto ende
exit

:beide
REM   TUC Profil kopieren
xcopy  /Y "%verz%config\*" "%ProgramFiles%\OpenVPN\config" > nul
REM   Windows Firewall automatisch konfigurieren
netsh advfirewall firewall add rule name="TUC OpenVPN UDP" dir=in action=allow program="%ProgramFiles%\openvpn\bin\openvpn.exe" enable=yes protocol=UDP edge=deferuser
netsh advfirewall firewall add rule name="TUC OpenVPN TCP" dir=in action=allow program="%ProgramFiles%\openvpn\bin\openvpn.exe" enable=yes protocol=TCP edge=deferuser
REM   Altes VPN Profil löschen
IF EXIST "%ProgramFiles%\OpenVPN\config\TUC_OpenVPN.ovpn" DEL /F "%ProgramFiles%\OpenVPN\config\TUC_OpenVPN.ovpn"
IF EXIST "%ProgramFiles%\OpenVPN\config\TUC_OpenVPN-Mitarbeiter.ovpn" DEL /F "%ProgramFiles%\OpenVPN\config\TUC_OpenVPN-Mitarbeiter.ovpn"
IF EXIST "%ProgramFiles%\OpenVPN\config\TUC_OpenVPN-Studenten.ovpn" DEL /F "%ProgramFiles%\OpenVPN\config\TUC_OpenVPN-Studenten.ovpn"
REM   OpenVPN Dienst starten
start /wait net start OpenVPNServiceInteractive
REM OpenVPN GUI starten
start "" "%ProgramFiles%\OpenVPN\bin\openvpn-gui.exe"
@echo off
cls
echo.
echo ===========================================
echo *                                         *
echo *    VPN wurde erfolgreich installiert    *
echo *                                         *
echo ===========================================
goto ende
exit

:keinadmin
cls
echo.
echo           Fehler beim Ausfuehren
echo ============================================
echo *                                          *
echo *    Bitte starten Sie die Installation    *
echo *          als Administrator!!!            *
echo *                                          *
echo ============================================
goto ende
exit

:ende
Pause
exit